---
generated_at: 2026-02-04 10:09:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：10-Qt TS翻訳ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Qt Linguist TSスキーマとの完全互換性**：Qt公式スキーマとの照合は未実施

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Dumper/QtFileDumper.php`（1-55行目）
- E-02: `src/Symfony/Component/Translation/Dumper/FileDumper.php`（1-101行目）
- E-03: `src/Symfony/Component/Translation/MessageCatalogue.php`（1-316行目）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（11行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QtFileDumperはFileDumperを継承する | E-01 21行目 `class QtFileDumper extends FileDumper` | ○ |
| C-02 | ファイル拡張子は"ts" | E-01 51-54行目 `return 'ts'` | ○ |
| C-03 | DOMDocumentを使用してXML構築 | E-01 25行目 `new \DOMDocument('1.0', 'utf-8')` | ○ |
| C-04 | formatOutputが有効 | E-01 26行目 `$dom->formatOutput = true` | ○ |
| C-05 | ルート要素は`<TS>` | E-01 27行目 `$dom->createElement('TS')` | ○ |
| C-06 | context要素にname子要素（ドメイン名） | E-01 28-29行目 `createElement('context')`, `createElement('name', $domain)` | ○ |
| C-07 | message要素にsource/translation子要素 | E-01 44-45行目 `createElement('source', $source)`, `createElement('translation', $target)` | ○ |
| C-08 | metadata['sources']が存在する場合にlocation要素を生成 | E-01 34行目 `isset($metadata['sources'])` | ○ |
| C-09 | sourcesの各エントリをコロンで分割してfilename/line属性を設定 | E-01 36行目 `explode(':', $location, 2)` | ○ |
| C-10 | filename属性は常に設定 | E-01 38行目 `$location->setAttribute('filename', $loc[0])` | ○ |
| C-11 | line属性はコロン分割結果の2番目が存在する場合のみ設定 | E-01 39-41行目 `if (isset($loc[1]))` | ○ |
| C-12 | saveXML()でXML文字列を返す | E-01 48行目 `$dom->saveXML()` | ○ |
| C-13 | pathオプションは必須 | E-02 43-45行目 | ○ |
| C-14 | メタデータのうちsourcesのみを使用 | E-01 33-43行目 metadataの参照はsourcesのみ | ○ |
| C-15 | Qt Linguist TSスキーマに完全準拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: Qt LinguistのTSファイルスキーマ（DTD/XSD）との詳細な照合は未実施。出力されるXML構造がQt Linguistで正しく読み込めるかは実動作確認が必要
  - 候補：Qt公式ドキュメント / Qt Linguistソースコード / `qttools/src/shared/ts.dtd`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなXML構造であり、ソースコードから直接確認可能
- 1: 中リスク - Qt Linguist TSスキーマとの完全互換性は外部ツールでの確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されたTSファイルがQt Linguistで正しく開けるか確認
- [ ] Qt TS形式のDTD/XSDとの整合性を確認
- [ ] metadata['sources']の"filename:line"形式が適切にパースされるか確認
